<?php

#	SonicCampGuard
#
#	Copyright (c) 2024 Bundeswehr
#	Diese Anwendung wurde von Cedric Prietz entwickelt.
#	E-Mail: CedricPrietz@bundeswehr.org
#	App: 90-8303-54618
#
#	Letzte Änderung: 24.01.2025

require_once $_SERVER['DOCUMENT_ROOT'] . '/function.inc.php';
pageName("Benutzerkonten");
requireLogin();
requireRole('Administrator');
showSessionAlert();

include($_SERVER['DOCUMENT_ROOT'] . '/header.inc.php');
?>
<div class="d-flex justify-content-between align-items-center flex-wrap grid-margin">
    <div>
        <h4 class="mb-3 mb-md-0">Benutzerkonten</h4>
        <span class="text-secondary">Administration</span>
    </div>
    <div class="d-flex align-items-center flex-wrap text-nowrap">
        <a href="/administration/new-account" class="btn btn-primary btn-icon-text mb-2 mb-md-0">
            <i class="btn-icon-prepend" data-feather="user-plus"></i>
            Hinzufügen
        </a>
    </div>
</div>

<div class="row">

    <div class="col-lg-12 col-xl-12 grid-margin stretch-card">
        <div class="card">
            <div class="card-header bg-primary text-white">
                Benutzerkonten
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered mb-0">
                        <thead>
                            <tr>
                                <th style="white-space: nowrap; width: 1%;">Typ</th>
                                <th width="25%">Benutzername</th>
                                <th width="25%">Vollständiger Name</th>
                                <th width="25%">Benutzerrolle</th>
                                <th width="25%">Letzter Login</th>
                                <th style="white-space: nowrap; width: 1%;">Optionen</th>
                            </tr>
                        </thead>
                        <tbody>

                            <?php
                            // Initialisiere Datenbankverbindung
                            initializeDatabaseConnection();

                            // SQL-Abfrage vorbereiten
                            $sql = "SELECT ID, Type, Username, DisplayName, Role, LastLogin FROM Accounts";

                            // Abfrage ausführen
                            $stmt = $pdo->query($sql);

                            // Alle Datensätze abholen
                            $Accounts = $stmt->fetchAll();

                            // Überprüfen, ob Datensätze vorhanden sind
                            if ($Accounts) {
                                // Ausgabe der Daten
                                foreach ($Accounts as $account) {
                                    echo "<tr>";
                                    if ($account['Type'] == 'ldap') {
                                        echo '<td><span class="badge bg-primary">LDAP</span></td>';
                                    }
                                    if ($account['Type'] == 'local') {
                                        echo '<td><span class="badge bg-warning">LOKAL</span></td>';
                                    }
                                    echo "<td>" . htmlspecialchars($account['Username']) . "</td>";
                                    echo "<td>" . htmlspecialchars($account['DisplayName']) . "</td>";
                                    echo "<td>" . htmlspecialchars($account['Role']) . "</td>";
                                    echo "<td>" . htmlspecialchars($account['LastLogin']) . "</td>";

                                    if ($account['ID'] != '1') {
                                        echo "<td style='padding: .60rem .85rem;'>
                                        <a href='/administration/edit-account?username=" . $account['Username'] . "' type='button' class='btn btn-sm btn-inverse-light btn-icon-text' style='margin: 0px;'>
                                            <i class='mdi mdi-text-box-edit'></i> Bearbeiten
                                        </a>
                                    </td>";
                                    } else {
                                        echo "<td></td>";
                                    }

                                    echo "</tr>";
                                }
                            }

                            ?>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-12 col-xl-12 grid-margin stretch-card">
        <div class="card">
            <div class="card-header bg-warning text-white">
                Rechte-Matrix
            </div>
            <div class="card-body">

                <div class="alert alert-primary" role="alert">
                    <i class="mdi mdi-information-slab-box-outline"></i>
                    Diese Funktion ist aktuell unvollständig und wird mit der nächsten Softwarepflege eingeführt.
                </div>

                <div class="table-responsive">
                    <table class="table table-bordered mb-0">
                        <thead>
                            <tr>
                                <th></th>
                                <th width="5%" style="writing-mode: vertical-lr;">Bediener</th>
                                <th width="5%" style="writing-mode: vertical-lr;">Bearbeiter</th>
                                <th width="5%" style="writing-mode: vertical-lr;">Auswerter</th>
                                <th width="5%" style="writing-mode: vertical-lr;">Auditor</th>
                                <th width="5%" style="writing-mode: vertical-lr;">Administrator</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>Dashboard</td>
                                <td class="text-center">X</td>
                                <td class="text-center">X</td>
                                <td class="text-center">X</td>
                                <td class="text-center">X</td>
                                <td class="text-center">X</td>
                            </tr>
                            <tr>
                                <td colspan="6" class="bg-light pt-1 pb-1 text-primary text-uppercase">
                                    Berichte
                                </td>
                            </tr>
                            <tr>
                                <td>Zonenauswertung</td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                            </tr>
                            <tr>
                                <td>Schutzräume</td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                            </tr>
                            <tr>
                                <td>Sicherheitsbelehrungen</td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                            </tr>
                            <tr>
                                <td>Militärische Abschirmdienst</td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                            </tr>
                            <tr>
                                <td colspan="6" class="bg-light pt-1 pb-1 text-primary text-uppercase">
                                    Identitäten
                                </td>
                            </tr>
                            <tr>
                                <td>Dienstposten Erstellen, Bearbeiten und Löschen</td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                            </tr>
                            <tr>
                                <td>Identitäten Erstellen, Bearbeiten und Löschen</td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                            </tr>
                            <tr>
                                <td colspan="6" class="bg-light pt-1 pb-1 text-primary text-uppercase">
                                    Auditing
                                </td>
                            </tr>
                            <tr>
                                <td>Berechtigungen Einsehen</td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                                <td class="text-center">X</td>
                            </tr>
                            <tr>
                                <td>Protokolle Einsehen und Exportieren</td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                                <td class="text-center">X</td>
                            </tr>
                            <tr>
                                <td>Buchungshistorie Einsehen und Exportieren</td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                                <td class="text-center">X</td>
                            </tr>
                            <tr>
                                <td colspan="6" class="bg-light pt-1 pb-1 text-primary text-uppercase">
                                    Administration
                                </td>
                            </tr>
                            <tr>
                                <td>Benutzerkonten Erstellen, Bearbeiten und Löschen</td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                            </tr>
                            <tr>
                                <td>Zonen Erstellen, Bearbeiten und Löschen</td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                            </tr>
                            <tr>
                                <td>Schutzräume Erstellen, Bearbeiten und Löschen</td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                            </tr>
                            <tr>
                                <td>Backup Erstellen und Exportieren</td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center"></td>
                                <td class="text-center">X</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

</div>

<?php include($_SERVER['DOCUMENT_ROOT'] . '/footer.inc.php'); ?>